<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class CTASimple extends Widget_Base{

  public function get_name(){
    return 'cta-simple';
  }

  public function get_title(){
    return 'CTA Simple';
  }

  public function get_icon(){
    return 'fa fa-exclamation-circle';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
    $this->add_control(
      'element_title',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Bridging gap between Business and Technology'
      ]
    );

    $this->add_control(
      'element_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since.'
      ]
    );
	
	
	
	$this->add_control(
		'background-image',
		[
			'label' => __( 'Choose Background Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/parallax3.jpg',
			],
		]
	);

	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Learn More'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'kriate' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );
	
	$this->add_control(
			'disable_dots',
			[
				'label' => __( 'Disable Particles', 'plugin-domain' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

	

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : ''; 
	
	/* Particles */
	if($settings['disable_dots']){
	wp_enqueue_script( 'particles-js', get_template_directory_uri() . '/assets/js/particles.min.js', array('jquery'), '1.0.0', true ); ?>
	
	<script>
	jQuery(document).ready(function($){
  'use strict';
  var particlesID = '';
  var particlesColor = '#fff';

  jQuery('.particles-js').each(function(i, el) {
    particlesID = jQuery(el).attr('id');
    if( jQuery(el).data('color') != undefined ){
      particlesColor = jQuery(el).data('color');
    }
    var test = particlesJS(particlesID,
    {
      "particles": {
        "number": {
          "value": 160,
          "density": {
            "enable": true,
            "value_area": 800
          }
        },
        "color": {
          "value": particlesColor
        },
        "shape": {
          "type": "circle",
          "stroke": {
            "width": 0,
            "color": "#000000"
          },
          "polygon": {
            "nb_sides": 5
          },
          "image": {
            "src": "img/github.svg",
            "width": 100,
            "height": 100
          }
        },
        "opacity": {
          "value": 1,
          "random": true,
          "anim": {
            "enable": true,
            "speed": 1,
            "opacity_min": 0,
            "sync": false
          }
        },
        "size": {
          "value": 4,
          "random": true,
          "anim": {
            "enable": false,
            "speed": 4,
            "size_min": 0.3,
            "sync": false
          }
        },
        "line_linked": {
          "enable": false,
          "distance": 150,
          "color": "#ffffff",
          "opacity": 0.4,
          "width": 1
        },
        "move": {
          "enable": true,
          "speed": 1,
          "direction": "none",
          "random": true,
          "straight": false,
          "out_mode": "out",
          "bounce": false,
          "attract": {
            "enable": false,
            "rotateX": 600,
            "rotateY": 600
          }
        }
      },
      "interactivity": {
        "detect_on": "canvas",
        "events": {
          "onhover": {
            "enable": true,
            "mode": "bubble"
          },
          "onclick": {
            "enable": true,
            "mode": "repulse"
          },
          "resize": true
        },
        "modes": {
          "grab": {
            "distance": 400,
            "line_linked": {
              "opacity": 1
            }
          },
          "bubble": {
            "distance": 250,
            "size": 0,
            "duration": 2,
            "opacity": 0,
            "speed": 3
          },
          "repulse": {
            "distance": 400,
            "duration": 0.4
          },
          "push": {
            "particles_nb": 4
          },
          "remove": {
            "particles_nb": 2
          }
        }
      },
      "retina_detect": true
    }

    );
  });
	});</script>
	
	<?php }  /* endif*/ ?>
	<section>
		<div class="w-100 pt-155 pb-155 blue-layer opc85 position-relative">
			<?php if($settings['background-image']['url']){ ?>
				<div class="fixed-bg" style="background-image: url(<?php echo esc_url($settings['background-image']['url']); ?>);"></div>
			<?php } ?>
			<div class="particles-js" id="prtcl4"></div>
			<div class="container">
				<div class="banner-wrap position-relative text-center w-100">
					<div class="banner-inner d-inline-block">
						<?php if($settings['element_title']){ ?><h2 class="mb-0"><?php echo esc_html($settings['element_title']); ?></h2><?php } ?>
						<?php if($settings['element_caption']){ ?><p class="mb-0"><?php echo esc_html($settings['element_caption']); ?></p><?php } ?>
						<?php if($settings['button_url']['url']){ ?><a class="thm-btn thm-bg" href="<?php echo esc_html($settings['button_url']['url']); ?>" title=""><?php echo esc_html($settings['button_text']); ?><i class="flaticon-arrow-pointing-to-right"></i></a><?php } ?>
					</div>
				</div><!-- Banner Wrap -->
			</div>
		</div>
	</section>
	
    <?php
  }
}
