<?php
namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class BlogGrid extends Widget_Base{

  public function get_name(){
    return 'blog_grid';
  }

  public function get_title(){
    return 'Blog Grid';
  }

  public function get_icon(){
    return 'fa fa-th-large';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
		$args = array(
			'type'                     => 'post',
			'child_of'                 => 0,
			'parent'                   => '',
			'orderby'                  => 'date',
			'order'                    => 'DESC',
			'hide_empty'               => 1,
			'hierarchical'             => 1,
			'exclude'                  => '',
			'include'                  => '',
			'number'                   => '',
			'taxonomy'                 => 'category',
			'pad_counts'               => false 
		);
		
		$categories = get_categories( $args ); 				
				
		
		$taxonomies = get_taxonomies();
		
		if($categories){
			$categoryArray[0] = "All";
			foreach($categories as $category_list){
				$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
			}
		} else {
			$categoryArray = array();
		}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );

	$this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'BLOG POSTS'
      ]
    );

    $this->add_control(
      'content_heading',
      [
        'label' => 'Element Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Our Latest News'
      ]
    ); 
	
	$this->add_control(
		'slider_yn',
		[
			'label' => __( 'Select Type', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'Yes',
			'options' => [
				'Yes'  => __( 'Slider', 'kriate' ),
				'No' => __( 'No Slider', 'kriate' ),
			],
		]
	);

	
	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 30,
			'step' => 1,
			'default' => 3,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '15'
      ]
    );

	
	$this->add_control(
      'button_text',
      [
        'label' => 'Button Text',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'More News & Updates'
      ]
    );
	
	$this->add_control(
		'button_url',
			[
				'label' => __( 'Button URL', 'kriate' ),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __( '#', 'kriate' ),
				'show_external' => true,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
    );

    $this->end_controls_section();
  }
  

  protected function render(){
    $settings = $this->get_settings_for_display();
	
	/* Get Posts */
    $posts = kriate_get_post_query('post', 'category', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']);
	
	if($settings['slider_yn'] == 'Yes'){
		wp_enqueue_style('slick-slider',get_template_directory_uri().'/assets/css/slick.css');
		wp_enqueue_script( 'slick-slider', get_template_directory_uri() . '/assets/js/slick.min.js', array('jquery'), '1.0.0', true ); 
	}

	/* button url */
	$btarget = $settings['button_url']['is_external'] ? ' target="_blank"' : '';
	$bnofollow = $settings['button_url']['nofollow'] ? ' rel="nofollow"' : '';
	
   $output = '
    
   <section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">';
				if($settings['content_heading'] || $settings['content_caption']){
				$output .= '
				<div class="sec-title w-100 faqs">
					<div class="sec-title-inner d-inline-block">
						<span class="d-block thm-clr">'.$settings['content_caption'].'</span>
						<h3 class="mb-0">'.$settings['content_heading'].'</h3>
					</div>
				</div>';
				}
				$output .= '
				<div class="blog-wrap w-100">
					<div class="row post-caro editted">';
						/* Loop Begins */
						if ( have_posts() ) {
						 
							while ( have_posts() ) { the_post(); global $post;
							
							/* Get Comment Count */
							$comment_count = wp_count_comments( $post->ID );
							
							$comment_count = $comment_count->total_comments;
							
							$featured_image_url = get_the_post_thumbnail_url($post->ID, array( 370, 220, 'bfi_thumb' => true ));
							
							if($featured_image_url){ $pad_class = ''; }else{ $pad_class = 'pt-30'; }
							
							$output .= '
							
								<div class="col-md-6 col-sm-6 col-lg-4">
									<div class="post-box w-100 text-center">';
									if($featured_image_url){ 
									$output .= '
										<div class="post-img w-100">
											<a href="'.get_the_permalink().'" title="">';
											
												$categories = get_the_category($post->ID);
												
												if ( ! empty( $categories ) ) {
													
												$output .= '<span class = "cato">';
												$output .= esc_html( $categories[0]->name );   
												$output .= '</span>';
												
												}
												
												$output .= '<img class="img-fluid w-100" src="'.esc_url($featured_image_url).'" alt="'.esc_attr__('Featured Image','kriate').'">
											</a>
										</div>';
									}
									$output .= '
										<div class="post-info '.$pad_class.' w-100">
											<ul class="post-meta mb-0 list-unstyled d-inline-flex">
												<li><i class="far fa-calendar-alt"></i>'.get_the_date('M d, Y').'</li>
												<li><i class="far fa-comment-dots"></i>'.$comment_count.' '.esc_html__('Comments','kriate').'</li>
											</ul>
											<h3 class="mb-0"><a href="'.get_the_permalink().'" title="">'.get_the_title().'</a></h3>
											<p class="mb-0">'.wp_trim_words( get_the_content(), $settings['words_count'], '...' ).'</p>
											<div class="post-info-bottom d-flex flex-wrap w-100">
												<span class="d-inline-block text-center"><i class="far fa-edit"></i><a href="'.get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ).'" title="">Posted By: '.get_the_author_meta( 'display_name' , $post->post_author ).'</a></span>
											</div>
										</div>
									</div>
								</div>';
							}
						} wp_reset_query();
						
						$output .= '
					</div>
				</div>';
				
				if($settings['button_text']){
					$output .= '
						<div class="view-all w-100 text-center">
							<a class="thm-btn thm-bg" href="'.$settings['button_url']['url'].'" title="">'.$settings['button_text'].'<i class="flaticon-arrow-pointing-to-right"></i></a>
						</div>';
				}
				$output .= '
			</div>
		</div>
	</section>';

	echo $output;
	
	}
}