<?php

namespace WPC\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class AboutUsIntro extends Widget_Base{

  public function get_name(){
    return 'about_us_intro';
  }

  public function get_title(){
    return 'About Us Intro';
  }

  public function get_icon(){
    return 'fa fa-file-text';
  }

  public function get_categories(){
    return ['nauthemes'];
  }

  protected function _register_controls(){
	  
	$args = array(
		'type'                     => 'services',
		'child_of'                 => 0,
		'parent'                   => '',
		'orderby'                  => 'date',
		'order'                    => 'DESC',
		'hide_empty'               => 1,
		'hierarchical'             => 1,
		'exclude'                  => '',
		'include'                  => '',
		'number'                   => '',
		'taxonomy'                 => 'services-cat',
		'pad_counts'               => false 
	);
	
	$categories = get_categories( $args ); 				
			
	
	$taxonomies = get_taxonomies();
		
	if($categories){
		$categoryArray[0] = "All";
		foreach($categories as $category_list){
			$categoryArray[$category_list->name] = __( $category_list->name, 'kriate' );
		}
	} else {
		$categoryArray = array();
	}

    $this->start_controls_section(
      'section_content',
      [
        'label' => 'Settings',
      ]
    );
	
	$this->add_control(
		'chose_style',
		[
			'label'     => esc_html__( 'Chose Style', 'kriate' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'options'   => [
				'style-one'  => esc_html__( 'Style 1', 'kriate' ),
				'style-two' => esc_html__( 'Style 2', 'kriate' ),
			],
			'default'   => 'style-one',
		]
	);
	
	$this->add_control(
      'content_caption',
      [
        'label' => 'Element Caption',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'WELCOME TO KRIATOR'
      ]
    );
	
	$this->add_control(
      'content_heading',
      [
        'label' => 'Element Heading',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'About Us Our Company.'
      ]
    );
	
	$this->add_control(
      'content_description',
      [
        'label' => 'Element Description',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'We craft beautifully useful marketing and digital products that grow'
      ]
    );
	
	$this->add_control(
      'colored_title',
      [
        'label' => 'Colored Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '- Our Blubuild.'
      ]
    );

	$this->add_control(
		'item_description',
		[
			'label' => __( 'Description', 'kriate' ),
			'type' => \Elementor\Controls_Manager::WYSIWYG,
			'rows' => 10,
			'default' => __( 'Sorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim admini veniam, quis nostru.', 'kriate' ),
			'placeholder' => __( 'Sorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim admini veniam, quis nostru.', 'kriate' ),
		]
	);

	$this->add_control(
		'select_category',
		[
			'label' => __( 'Select Category', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'All',
			'options' => $categoryArray,
		]
	);
	
	$this->add_control(
		'sortby',
		[
			'label' => __( 'Sort Posts By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'date',
			'options' => [
				'date'  => __( 'Date', 'kriate' ),
				'title' => __( 'Title', 'kriate' ),
				'name' => __( 'Name', 'kriate' ),
				'rand' => __( 'Random', 'kriate' ),
				'ID' => __( 'ID', 'kriate' ),
			],
		]
	);
	
	$this->add_control(
		'orderby',
		[
			'label' => __( 'Order By', 'kriate' ),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'DESC',
			'options' => [
				'DESC'  => __( 'DESCEDNING', 'kriate' ),
				'ASC' => __( 'ASCENDING', 'kriate' ),
			],
		]
	);

    $this->add_control(
      'posts_count',
		[
			'label' => __( 'Posts Count', 'kriate' ),
			'type' => \Elementor\Controls_Manager::NUMBER,
			'min' => 1,
			'max' => 40,
			'step' => 1,
			'default' => 4,
		]
    );
	
	$this->add_control(
      'words_count',
      [
        'label' => 'Words Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '8'
      ]
    );

	$this->add_control(
      'fact_count',
      [
        'label' => 'Fact Count',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '18'
      ]
    );
	
	$this->add_control(
      'fact_suffix',
      [
        'label' => 'Fact Suffix',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => '+'
      ]
    );
	
	$this->add_control(
      'fact_title',
      [
        'label' => 'Fact Title',
        'type' => \Elementor\Controls_Manager::TEXT,
        'default' => 'Experience'
      ]
    );
	
	$this->add_control(
		'main_image',
		[
			'label' => __( 'Choose Image', 'kriate' ),
			'type' => \Elementor\Controls_Manager::MEDIA,
			'default' => [
				'url' => get_template_directory_uri().'/assets/images/about-image1.jpg',
			],
		]
	);


    $this->end_controls_section();
  }
  

  protected function render(){
	  
    $settings = $this->get_settings_for_display(); 
	
	/* Get Posts */
    $posts = kriate_get_post_query('services', 'services-cat', $settings['select_category'], $settings['posts_count'], $settings['sortby'], $settings['orderby']); 
	
	if($settings['chose_style'] == 'style-one'){ ?>

	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="about-wrap w-100">
					<div class="row justify-content-center">
						<div class="col-md-12 col-sm-12 col-lg-10">
							<div class="about-content-wrap w-100">
								<div class="row">
								<?php if($settings['content_caption'] || $settings['content_heading']){ ?>
									<div class="col-md-12 col-sm-12 col-lg-4">
										<div class="sec-title title-with-shape w-100">
											<div class="sec-title-inner d-inline-block">
												<?php if($settings['content_caption']){ ?><span class="thm-clr d-block"><?php echo esc_html($settings['content_caption']); ?></span><?php } ?>
												<?php if($settings['content_heading']){ ?><h3 class="mb-0"><?php echo kriate_split_title($settings['content_heading']); ?></h3><?php } ?>
											</div>
										</div><!-- Sec Title -->
									</div>
								<?php } ?>
									<div class="col-md-12 col-sm-12 col-lg-8">
										<?php if($settings['content_description'] || $settings['item_description']){ ?>
											<div class="about-desc w-100">
												<?php if($settings['content_description']){ ?>
												<h2 class="mb-0">
													<?php echo esc_html($settings['content_description']); ?> 
													<strong class="thm-clr d-block"><?php echo esc_html($settings['colored_title']); ?></strong>
												</h2>
												<?php } ?>
												<?php if($settings['item_description']){ ?><p class="mb-0"><?php echo $settings['item_description']; ?></p><?php } ?>
											</div>
										<?php } ?>
										<div class="serv-wrap w-100">
											<div class="row">
											<?php
											if ( have_posts() ) {
												
												while ( have_posts() ) { the_post(); global $post;
								
												static $counter = 1; 
												
												$service_icon = '';
												$service_icon = get_post_meta( get_the_ID(), 'service_icon', true ); ?>
													
												<div class="col-md-6 col-sm-6 col-lg-6">
													<div class="serv-box w-100">
														<?php if($service_icon){ ?><i class="thm-clr <?php echo esc_html($service_icon); ?>"></i><?php } ?>
														<div class="serv-box-inner">
															<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
															<p class="mb-0"><?php echo wp_trim_words( get_the_excerpt(), $settings['words_count'], '...' ); ?></p>
														</div>
													</div>
												</div>
												
												<?php }
											} wp_reset_query(); ?>
											</div>
										</div><!-- Services Wrap -->
									</div>
								</div>
							</div>	
							<?php if($settings['main_image']['url']){ ?>
							<div class="about-image position-relative w-100">
								<?php if($settings['fact_count'] || $settings['fact_title']){ ?><span><?php echo esc_html($settings['fact_count']); ?><sup><?php echo esc_html($settings['fact_suffix']); ?></sup><i class="d-block"><?php echo esc_html($settings['fact_title']); ?></i></span><?php } ?>
								<img class="img-fluid w-100 brd-rd5" src="<?php echo esc_url($settings['main_image']['url']); ?>" alt="<?php esc_attr__('Featured Image','kriate'); ?>">
							</div>
							<?php } ?>
						</div>
					</div>
				</div><!-- About Wrap -->
			</div>
		</div>
	</section>
	
	<?php } 
	
	if($settings['chose_style'] == 'style-two'){ ?>
	
	<section>
		<div class="w-100 pt-100 pb-100 position-relative">
			<div class="container">
				<div class="about-wrap style2 w-100">
					<div class="row align-items-center justify-content-center">
						<div class="col-md-5 col-sm-12 col-lg-5 order-lg-1">
							<div class="about-image position-relative w-100">
								<?php if($settings['fact_count']){ ?><span><?php echo esc_html($settings['fact_count']); ?><sup><?php echo esc_html($settings['fact_suffix']); ?></sup><i class="d-block"><?php echo esc_html($settings['fact_title']); ?></i></span><?php } ?>
								<img class="img-fluid w-100 brd-rd5" src="<?php echo esc_url($settings['main_image']['url']); ?>" alt="<?php esc_attr__('Featured Image','kriate'); ?>">
							</div>
						</div>
						<div class="col-md-7 col-sm-12 col-lg-7">
							<?php if($settings['content_description'] || $settings['item_description']){ ?>
								<div class="about-desc w-100">
									<?php if($settings['content_description']){ ?>
										<h2 class="mb-0">
											<?php echo esc_html($settings['content_description']); ?> 
											<strong class="thm-clr d-block"><?php echo esc_html($settings['colored_title']); ?></strong>
										</h2>
									<?php } ?>
									
									<?php if($settings['item_description']){ ?><p class="mb-0"><?php echo $settings['item_description']; ?></p><?php } ?>
								</div>
							<?php } ?>
							<div class="serv-wrap w-100">
								<div class="row">
									<?php
									if ( have_posts() ) {
										
										while ( have_posts() ) { the_post(); global $post;
						
										static $counter = 1; 
										
										$service_icon = '';
										$service_icon = get_post_meta( get_the_ID(), 'service_icon', true ); ?>
											
										<div class="col-md-12 col-sm-6 col-lg-6">
											<div class="serv-box w-100">
												<?php if($service_icon){ ?><i class="thm-clr <?php echo esc_html($service_icon); ?>"></i><?php } ?>
												<div class="serv-box-inner">
													<h3 class="mb-0"><a href="<?php echo get_the_permalink(); ?>" title=""><?php echo get_the_title(); ?></a></h3>
													<p class="mb-0"><?php echo wp_trim_words( get_the_excerpt(), $settings['words_count'], '...' ); ?></p>
												</div>
											</div>
										</div>
										
										<?php }
									} wp_reset_query(); ?>
								</div>
							</div><!-- Services Wrap -->
						</div>
					</div>
				</div><!-- About Wrap -->
			</div>
		</div>
	</section>
	
	<?php } ?>
	
    <?php
  }
}